jQuery(document).ready(function ($) {
    'use strict';
    function toggleTabConfiguration() {
        var selectedPosition = $('input[name="woonutri_options[display_position]"]:checked').val();
        var tabConfigElements = $('.woonutri-tab-config');

        if (selectedPosition === 'summary') {

            tabConfigElements.slideUp(300);
        } else {

            tabConfigElements.slideDown(300);
        }
    }
    toggleTabConfiguration();
    if (typeof $.fn.wpColorPicker === 'function') {
        $('.woonutri-color-picker').wpColorPicker({
            change: function(event, ui) {

                var $input = $(this);

                setTimeout(function() {

                    if (typeof window.previewTheme === 'function') {

                        var currentTheme = $('.woonutri-theme-btn.active').data('theme') || 'basic';
                        window.previewTheme(currentTheme);
                    }
                }, 50);
            },
            clear: function() {

                if (typeof window.previewTheme === 'function') {
                    var currentTheme = $('.woonutri-theme-btn.active').data('theme') || 'basic';
                    window.previewTheme(currentTheme);
                }
            }
        });
    }
    $(document).on('change', 'select[name="woonutri_options[font_family]"], select[name="woonutri_options[font_size]"], select[name="woonutri_options[table_layout]"], select[name="woonutri_options[border_radius]"]', function() {

        if (typeof window.previewTheme === 'function') {
            var currentTheme = $('.woonutri-theme-btn.active').data('theme') || 'basic';
            window.previewTheme(currentTheme);
        }
    });
    $(document).on('change', '.woonutri-radio-card input[type="radio"]', function () {
        $(this).closest('.woonutri-radio-group').find('.woonutri-radio-card').removeClass('checked');
        $(this).closest('.woonutri-radio-card').addClass('checked');
    });
    $(document).on('click', '.woonutri-theme-card', function (e) {
        var $card = $(this);
        var theme = $card.data('theme');

        if (!theme) return;
        if (typeof window.previewTheme === 'function') {
            window.previewTheme(theme);
            $('.woonutri-theme-btn').removeClass('active');
            $('.woonutri-theme-btn[data-theme="' + theme + '"]').addClass('active');
        }
        $('.woonutri-theme-card').removeClass('previewing');
        $card.addClass('previewing');
        if ($card.hasClass('woonutri-theme-locked')) {
            e.preventDefault();
            e.stopPropagation();
        }
    });
    $(document).on('click', '.woonutri-theme-chip', function (e) {
        e.preventDefault();
        var $chip = $(this);
        var theme = $chip.data('theme');

        if (!theme) return;
        var isLocked = $chip.hasClass('locked');
        if (typeof window.previewTheme === 'function') {
            window.previewTheme(theme);
            $('.woonutri-theme-btn').removeClass('active');
            $('.woonutri-theme-btn[data-theme="' + theme + '"]').addClass('active');
        }
        $('.woonutri-theme-chip').removeClass('active');
        $chip.addClass('active');
        if (!isLocked) {
            $('#woonutri-theme-input').val(theme);
        }
    });
    $(document).on('change', 'input[name="woonutri_options[font_size]"]', function () {
        var value = $(this).val();
        if (value === 'custom') {
            $('.woonutri-custom-font-size').slideDown(200);
        } else {
            $('.woonutri-custom-font-size').slideUp(200);
        }
    });
    window.updateRadioCards = function (el) {

    };
    $('input[name="woonutri_options[display_position]"]').on('change', function () {
        toggleTabConfiguration();
    });
    $('input[name="woonutri_options[display_position]"]').on('change', function () {

        $('#woonutri-display-position label').removeClass('woonutri-active-option');
        $(this).closest('label').addClass('woonutri-active-option');
    });
    var checkedRadio = $('input[name="woonutri_options[display_position]"]:checked');
    if (checkedRadio.length) {
        checkedRadio.closest('label').addClass('woonutri-active-option');
    }
    function initModernTabs() {

        $('.woonutri-tab-btn').off('click.woonutri');
        $('.woonutri-tab-btn').on('click.woonutri', function (e) {
            e.preventDefault();
            e.stopPropagation();

            var $clickedTab = $(this);
            var tabId = $clickedTab.data('tab');

            if (!tabId) {
                return;
            }
            $('.woonutri-tab-btn').removeClass('active');
            $('.woonutri-tab-panel').removeClass('active');
            $clickedTab.addClass('active');
            var $targetPanel = $('[data-panel="' + tabId + '"]');

            if ($targetPanel.length) {
                $targetPanel.addClass('active');
            }
            localStorage.setItem('woonutri_active_tab', tabId);
        });
        $('.woonutri-tab-btn').css('cursor', 'pointer');
        var activeTab = localStorage.getItem('woonutri_active_tab');
        if (activeTab && $('[data-panel="' + activeTab + '"]').length && $('[data-tab="' + activeTab + '"]').length) {
            $('.woonutri-tab-btn').removeClass('active');
            $('.woonutri-tab-panel').removeClass('active');
            $('[data-tab="' + activeTab + '"]').addClass('active');
            $('[data-panel="' + activeTab + '"]').addClass('active');
        } else {

            var $firstTab = $('.woonutri-tab-btn').first();
            var $firstPanel = $('.woonutri-tab-panel').first();

            $('.woonutri-tab-btn').removeClass('active');
            $('.woonutri-tab-panel').removeClass('active');

            $firstTab.addClass('active');
            $firstPanel.addClass('active');
        }
    }
    if ($('.woonutri-modern-tabs').length) {
        initModernTabs();
    }
    $('.woonutri-tab-content a[href^="#"]').on('click', function (e) {
        var target = $(this.getAttribute('href'));
        if (target.length) {
            e.preventDefault();
            $('html, body').stop().animate({
                scrollTop: target.offset().top - 100
            }, 500);
        }
    });
    $('.woonutri-dismiss-notice').on('click', function (e) {
        e.preventDefault();

        var $button = $(this);
        var nonce = $button.data('nonce');
        var period = $button.data('period');
        var notice = $('#woonutri-upgrade-notice');
        $('.woonutri-dismiss-notice').prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'woonutri_dismiss_notice',
                nonce: nonce,
                period: period
            },
            success: function (response) {
                if (response.success) {

                    var message = response.data.message || 'Notice dismissed';
                    var $success = $('<div class="notice notice-success is-dismissible" style="margin: 5px 0;"><p>' + message + '</p></div>');
                    notice.after($success);
                    setTimeout(function () {
                        notice.fadeOut(300, function () {
                            $(this).remove();
                        });
                        $success.fadeOut(300, function () {
                            $(this).remove();
                        });
                    }, 2000);
                } else {

                    $('.woonutri-dismiss-notice').prop('disabled', false);
                }
            },
            error: function () {
                $('.woonutri-dismiss-notice').prop('disabled', false);
            }
        });
    });

    $('.woonutri-clear-cache').on('click', function (e) {
        e.preventDefault();

        var $button = $(this);
        var $message = $('.woonutri-cache-message');
        var nonce = $button.data('nonce');

        $button.prop('disabled', true).text('Clearing...');
        $message.text('').removeClass('success error');

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'woonutri_clear_cache',
                nonce: nonce
            },
            success: function (response) {
                if (response.success) {
                    $message.css('color', 'green').text(response.data.message);
                } else {
                    $message.css('color', 'red').text(response.data.message || 'Error clearing cache');
                }
            },
            error: function () {
                $message.css('color', 'red').text('Request failed');
            },
            complete: function () {
                $button.prop('disabled', false).text('Clear Cache');
                setTimeout(function () {
                    $message.fadeOut(500, function () {
                        $(this).text('').show();
                    });
                }, 3000);
            }
        });
    });
});