
(function ($) {
    'use strict';
    const MAX_PRODUCTS = 3;
    const STORAGE_KEY = 'woonutri_compare_list';
    function getCompareList() {
        try {
            const stored = localStorage.getItem(STORAGE_KEY);
            return stored ? JSON.parse(stored) : [];
        } catch (e) {
            return [];
        }
    }
    function saveCompareList(list) {
        try {
            localStorage.setItem(STORAGE_KEY, JSON.stringify(list));
        } catch (e) {

        }
    }
    function addToCompare(productId, productName, productImage) {
        const list = getCompareList();
        if (list.some(item => item.id === productId)) {
            return false;
        }
        if (list.length >= MAX_PRODUCTS) {
            alert(woonutri_compare.i18n.max_products);
            return false;
        }

        list.push({
            id: productId,
            name: productName,
            image: productImage
        });

        saveCompareList(list);
        updateCompareUI();
        return true;
    }
    function removeFromCompare(productId) {
        let list = getCompareList();
        list = list.filter(item => item.id !== productId);
        saveCompareList(list);
        updateCompareUI();
    }
    function clearCompare() {
        saveCompareList([]);
        updateCompareUI();
    }
    function updateCompareUI() {
        const list = getCompareList();
        $('.woonutri-add-compare').each(function () {
            const productId = parseInt($(this).data('product-id'));
            const isInList = list.some(item => item.id === productId);

            $(this)
                .toggleClass('added', isInList)
                .find('span:last')
                .text(isInList ? woonutri_compare.i18n.remove : woonutri_compare.i18n.add_to_compare);
        });
        updateFloatingBar(list);
    }
    function updateFloatingBar(list) {
        let $bar = $('.woonutri-compare-bar');
        if (!$bar.length) {
            $bar = $('<div class="woonutri-compare-bar">' +
                '<div class="woonutri-compare-bar-items"></div>' +
                '<button class="woonutri-compare-btn">' + woonutri_compare.i18n.compare + '</button>' +
                '<button class="woonutri-clear-btn button">' + woonutri_compare.i18n.clear_all + '</button>' +
                '</div>');
            $('body').append($bar);
            $bar.find('.woonutri-compare-btn').on('click', showComparison);
            $bar.find('.woonutri-clear-btn').on('click', clearCompare);
        }
        const $items = $bar.find('.woonutri-compare-bar-items');
        $items.empty();

        list.forEach(function (item) {
            $items.append(
                '<div class="woonutri-compare-bar-item" data-id="' + item.id + '">' +
                (item.image ? '<img src="' + item.image + '" alt="">' : '') +
                '<span class="name">' + item.name + '</span>' +
                '<span class="remove" title="Remove">&times;</span>' +
                '</div>'
            );
        });
        $items.find('.remove').off('click').on('click', function () {
            const id = parseInt($(this).closest('.woonutri-compare-bar-item').data('id'));
            removeFromCompare(id);
        });
        $bar.toggleClass('show', list.length > 0);
    }
    function showComparison() {
        const list = getCompareList();

        if (list.length < 2) {
            alert('Please add at least 2 products to compare.');
            return;
        }

        const productIds = list.map(item => item.id);
        let $modal = $('.woonutri-compare-modal');
        if (!$modal.length) {
            $modal = $(
                '<div class="woonutri-compare-modal">' +
                '<div class="woonutri-compare-modal-overlay"></div>' +
                '<div class="woonutri-compare-modal-content">' +
                '<button class="woonutri-compare-modal-close">&times;</button>' +
                '<div class="woonutri-compare-modal-body"><div class="loading">Loading...</div></div>' +
                '</div>' +
                '</div>'
            );
            $('body').append($modal);
            $modal.find('.woonutri-compare-modal-close, .woonutri-compare-modal-overlay').on('click', function () {
                $modal.removeClass('show');
            });
        }

        $modal.addClass('show');
        $.ajax({
            url: woonutri_compare.ajax_url,
            type: 'POST',
            data: {
                action: 'woonutri_get_comparison',
                nonce: woonutri_compare.nonce,
                product_ids: productIds
            },
            success: function (response) {
                if (response.success) {
                    $modal.find('.woonutri-compare-modal-body').html(response.data.html);
                } else {
                    $modal.find('.woonutri-compare-modal-body').html(
                        '<div class="error">' + (response.data.message || 'Error loading comparison') + '</div>'
                    );
                }
            },
            error: function () {
                $modal.find('.woonutri-compare-modal-body').html(
                    '<div class="error">Error loading comparison. Please try again.</div>'
                );
            }
        });
    }
    $(document).ready(function () {
        $(document).on('click', '.woonutri-add-compare', function (e) {
            e.preventDefault();

            const $btn = $(this);
            const productId = parseInt($btn.data('product-id'));
            const productName = $btn.data('product-name') || 'Product';
            let productImage = '';
            const $productImage = $btn.closest('.product').find('.woocommerce-product-gallery__image img, .attachment-woocommerce_thumbnail').first();
            if ($productImage.length) {
                productImage = $productImage.attr('src');
            }
            const list = getCompareList();
            const isInList = list.some(item => item.id === productId);

            if (isInList) {
                removeFromCompare(productId);
                $btn.removeClass('added');
            } else {
                if (addToCompare(productId, productName, productImage)) {
                    $btn.addClass('added');
                }
            }
        });
        updateCompareUI();
        $(document).on('keyup', function (e) {
            if (e.key === 'Escape') {
                $('.woonutri-compare-modal').removeClass('show');
            }
        });
    });
    $('<style>')
        .text(`
            .woonutri-compare-modal {
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                z-index: 99999;
                display: none;
            }
            .woonutri-compare-modal.show {
                display: block;
            }
            .woonutri-compare-modal-overlay {
                position: absolute;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(0, 0, 0, 0.5);
            }
            .woonutri-compare-modal-content {
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                background: white;
                border-radius: 12px;
                max-width: 90%;
                max-height: 80vh;
                overflow: auto;
                box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
                min-width: 600px;
            }
            .woonutri-compare-modal-close {
                position: absolute;
                top: 10px;
                right: 15px;
                font-size: 28px;
                background: none;
                border: none;
                cursor: pointer;
                color: #666;
                z-index: 10;
            }
            .woonutri-compare-modal-close:hover {
                color: #000;
            }
            .woonutri-compare-modal-body {
                padding: 30px;
            }
            .woonutri-compare-modal-body .loading {
                text-align: center;
                padding: 40px;
                color: #666;
            }
            .woonutri-compare-modal-body .error {
                padding: 20px;
                background: #f8d7da;
                color: #721c24;
                border-radius: 6px;
            }
            @media (max-width: 768px) {
                .woonutri-compare-modal-content {
                    min-width: 95%;
                    max-width: 95%;
                }
            }
        `)
        .appendTo('head');

})(jQuery);
