
(function($) {
    'use strict';

    const WooNutriDashboard = {
        init: function() {
            this.animateStats();
            this.bindEvents();
            this.initCategoryFilter();
        },

        animateStats: function() {

            $('.woonutri-stat-card .stat-value').each(function() {
                const $this = $(this);
                const value = $this.text();
                const numericValue = parseFloat(value.replace(/[^0-9.]/g, ''));
                const suffix = value.replace(/[0-9.,]/g, '');

                if (!isNaN(numericValue)) {
                    $({ count: 0 }).animate({ count: numericValue }, {
                        duration: 1000,
                        easing: 'swing',
                        step: function() {
                            const current = Math.floor(this.count);
                            $this.text(current.toLocaleString() + suffix);
                        },
                        complete: function() {
                            $this.text(numericValue.toLocaleString() + suffix);
                        }
                    });
                }
            });
            setTimeout(function() {
                $('.stat-progress-bar, .bar-fill').each(function() {
                    const width = $(this).css('width');
                    $(this).css('width', '0').animate({ width: width }, 800);
                });
            }, 300);
        },

        initCategoryFilter: function() {

            $('input[name="category_filter_mode"]').on('change', function() {
                const mode = $(this).val();
                if (mode === 'all') {
                    $('.filter-categories').slideUp(300);
                } else {
                    $('.filter-categories').slideDown(300);
                }
            });
        },

        bindEvents: function() {
            const self = this;
            $(document).on('click', '#woonutri-refresh-stats', this.refreshStats);
            $(document).on('click', '#woonutri-save-filter', function(e) {
                e.preventDefault();
                self.saveCategoryFilter();
            });
        },

        saveCategoryFilter: function() {
            const $btn = $('#woonutri-save-filter');
            const mode = $('input[name="category_filter_mode"]:checked').val();
            const categories = [];

            $('input[name="category_filter_ids[]"]:checked').each(function() {
                categories.push($(this).val());
            });

            $btn.prop('disabled', true).text('Saving...');

            $.post(woonutriDashboard.ajax_url, {
                action: 'woonutri_save_category_filter',
                nonce: woonutriDashboard.nonce,
                mode: mode,
                categories: categories
            }, function(response) {
                if (response.success) {

                    $btn.text('Saved!').addClass('button-success');
                    setTimeout(function() {
                        location.reload();
                    }, 500);
                } else {
                    $btn.prop('disabled', false).text('Apply Filter');
                    alert(response.data.message || 'Error saving filter');
                }
            }).fail(function() {
                $btn.prop('disabled', false).text('Apply Filter');
                alert('Error saving filter. Please try again.');
            });
        },

        refreshStats: function(e) {
            e.preventDefault();
            const $btn = $(this);

            $btn.prop('disabled', true).addClass('loading');

            $.post(woonutriDashboard.ajax_url, {
                action: 'woonutri_get_dashboard_stats',
                nonce: woonutriDashboard.nonce
            }, function(response) {
                if (response.success) {
                    location.reload();
                }
                $btn.prop('disabled', false).removeClass('loading');
            });
        }
    };

    $(document).ready(function() {
        WooNutriDashboard.init();
    });

})(jQuery);
